<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductAttribute extends Model 
{

    protected $table = 'product_attribute';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('attribute_id', 'value_en', 'value_th');
    protected $visible = array('attribute_id', 'value_en', 'value_th');

    public function products()
    {
        return $this->belongsTo('Product', 'product_id');
    }

    public function attributes()
    {
        return $this->belongsTo('Attribute', 'attribute_id');
    }

}